#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

double time_to_overtake(int N, int K, vector<int>& x, vector<int>& v, double t) {
    vector<double> positions(N);
    for (int i = 0; i < N; ++i) {
        positions[i] = x[i] + t * v[i];
    }

    sort(positions.begin(), positions.end());

    int cnt = 0;
    for (int i = 0; i < N; ++i) {
        cnt += N - (lower_bound(positions.begin(), positions.end(), x[i] + t * v[i]) - positions.begin());
    }

    return cnt;
}

double find_overtake_time(int N, int K, vector<int>& x, vector<int>& v) {
    double low = 0.0, high = 1e9;

    for (int iter = 0; iter < 100; ++iter) {
        double mid = (low + high) / 2;

        if (time_to_overtake(N, K, x, v, mid) >= K) {
            high = mid;
        } else {
            low = mid;
        }
    }

    return low;
}

int main() {
    // Unos podataka
    int N, K;
    cin >> N >> K;

    vector<int> x(N);
    vector<int> v(N);

    for (int i = 0; i < N; ++i) {
        cin >> x[i] >> v[i];
    }

    // Pronalaženje trenutka K-tog preticanja
    double result = find_overtake_time(N, K, x, v);

    // Ispis rezultata
    cout << fixed << result << endl;

    return 0;
}